<?php
namespace Widget\InvoiceBundle\Tests\Service;


use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;

class InvoiceValidatorTest extends BaseKernelTestCase
{
    public function test_validate_基本欄位需求()
    {
        //arrange
        $invoiceInfo = array();
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayHasKey('email', $result);
        $this->assertArrayHasKey('mark', $result);
    }

    public function test_validate_錯誤基本欄位()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'bad_email',
            'mark' => '0',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayHasKey('email', $result);
        $this->assertArrayHasKey('mark', $result);
    }

    public function test_validate_愛心碼格式錯誤()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'd',
            'loveCode' => 'X121212',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('loveCode', $result);
    }

    public function test_validate_沒有填愛心碼()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'd',
            'loveCode' => '',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('loveCode', $result);
    }

    public function test_validate_載具類別錯誤()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'e',
            'carrierType' => '3',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('carrierType', $result);
    }

    public function test_validate_預設載具不能有載具代碼()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'e',
            'carrierType' => '0',
            'carrierId' => '12345',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('carrierId', $result);
    }

    public function test_validate_載具類別為手機條碼_載具代碼不能為空()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'e',
            'carrierType' => '1',
            'carrierId' => '',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('carrierId', $result);
    }

    public function test_validate_載具類別為自然人憑證_載具代碼不能為空()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'e',
            'carrierType' => '2',
            'carrierId' => '',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('carrierId', $result);
    }

    public function test_validate_紙本電子發票_發票收件人姓名_不能為空()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'p',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('buyerName', $result);
    }

    public function test_validate_紙本電子發票_發票寄送地址_不能為空()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'p',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('buyerAddress', $result);
    }

    public function test_validate_紙本電子發票_發票寄送地址郵遞區號_不能為空()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'p',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('buyerAddressZip', $result);
    }

    public function test_validate_地址郵遞區號格式錯誤()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'p',
            'buyerAddressZip' => 'A123',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayNotHasKey('mark', $result);
        $this->assertArrayHasKey('buyerAddressZip', $result);
    }

    public function test_validate_若需要打統編發票開立型式需設為紙本電子發票()
    {
        //arrange
        $invoiceInfo = array(
            'email' => 'ricky@dgfactor.com',
            'mark' => 'e',
            'companyId' => '1234567',
        );
        $invoiceValidator = $this->container->get('invoice_validator');

        //act
        $result = $invoiceValidator->validate($invoiceInfo);

        //assert
        $this->assertArrayNotHasKey('email', $result);
        $this->assertArrayHasKey('mark', $result);
    }
}
