<?php
namespace Widget\InvoiceBundle\Tests\Service;

use Backend\BaseBundle\Tests\Fixture\BaseKernelTestCase;
use Widget\InvoiceBundle\Event\GetInvoiceItemEvent;
use Widget\InvoiceBundle\Model\Invoice;
use Widget\InvoiceBundle\Model\InvoiceQuery;
use Widget\InvoiceBundle\Service\AbstractInvoice;
use Widget\OrderBundle\Model\OrderQuery;

abstract class MockAbstractInvoice extends AbstractInvoice
{
    const API_TYPE = "Mockapi";
}

class AbstractInvoiceTest extends BaseKernelTestCase
{

    public function test_create()
    {
        //arrange
        $config = array(
            'create_after' => 3,
        );

        $eventDispatcher = $this->getMockBuilder(EventDispatcher::class)
            ->setMethods(array('dispatch'))
            ->disableOriginalConstructor()
            ->getMock();

        $orderId = 'P0000';
        $order = OrderQuery::create()->findPk($orderId);
        $email = 'ricky@dgfactor.com';
        $donateMark = '2';
        $carrierType = 'CJ0003';
        $carrierId = '1234567';
        $loveCode = '54321';
        $identifier = '12853714';
        $name = '數位因子';
        $zip = '123';
        $address = 'test_address';
        $con = \Propel::getConnection();

        $eventDispatcher
            ->expects($this->once())
            ->method('dispatch')
            ->willReturnCallback(function($eventName, GetInvoiceItemEvent $event) use($con, $email, $donateMark, $carrierId, $carrierType, $loveCode, $identifier, $name, $zip, $address){
                $invoice = $event->getInvoice();
                $this->assertInstanceOf(Invoice::class, $invoice);
                $this->assertEquals($con, $event->getCon());
                $this->assertEquals(GetInvoiceItemEvent::EVENT_NAME, $eventName);
                $this->assertInstanceOf(GetInvoiceItemEvent::class, $event);
                $this->assertEquals($email, $invoice->getEmail());
                $this->assertEquals($donateMark, $invoice->getDonateMark());
                $this->assertEquals($carrierType, $invoice->getCarrierType());
                $this->assertEquals($carrierId, $invoice->getCarrierId());
                $this->assertEquals($loveCode, $invoice->getLoveCode());
                $this->assertEquals($identifier, $invoice->getIdentifier());
                $this->assertEquals($name, $invoice->getName());
                $this->assertEquals($zip, $invoice->getZip());
                $this->assertEquals($address, $invoice->getAddress());
                $this->assertEquals(MockAbstractInvoice::API_TYPE, $invoice->getApiType());
            });
        $invoiceService = $this->getMockBuilder(MockAbstractInvoice::class)
            ->getMockForAbstractClass();
        $this->setObjectAttribute($invoiceService, 'config', $config);
        $this->setObjectAttribute($invoiceService, 'eventDispatcher', $eventDispatcher);
        $con->beginTransaction();

        //act
        $result = $invoiceService->create($order->getId(), $email, $donateMark, $carrierType, $carrierId, $loveCode, $identifier, $name, $zip, $address, $con);
        $invoice = InvoiceQuery::create()->findPk($orderId, $con);
        $con->rollBack();

        //assert
        $this->assertInstanceOf(Invoice::class, $result);
        $this->assertInstanceOf(Invoice::class, $invoice);
        $this->assertEquals($email, $invoice->getEmail());
        $this->assertEquals($donateMark, $invoice->getDonateMark());
        $this->assertEquals($carrierType, $invoice->getCarrierType());
        $this->assertEquals($carrierId, $invoice->getCarrierId());
        $this->assertEquals($loveCode, $invoice->getLoveCode());
        $this->assertEquals($identifier, $invoice->getIdentifier());
        $this->assertEquals($name, $invoice->getName());
        $this->assertEquals($zip, $invoice->getZip());
        $this->assertEquals($address, $invoice->getAddress());
        $this->assertEquals(MockAbstractInvoice::API_TYPE, $invoice->getApiType());
    }

    public function test_send()
    {
        //arrange
        $con = \Propel::getConnection();
        $invoice1 = new Invoice();
        $invoice1->setId('id1')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoice2 = new Invoice();
        $invoice2->setId('id2')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoice3 = new Invoice();
        $invoice3->setId('id3')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoiceService = $this->getMockBuilder(MockAbstractInvoice::class)
            ->setMethods(array('sendOne'))
            ->getMockForAbstractClass();
        $invoiceService
            ->expects($this->at(0))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id1', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->at(1))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id2', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->at(2))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id3', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->exactly(3))
            ->method('sendOne');
        $now = new \DateTime();

        //act
        $invoiceService->send($now, $con);

        //assert
        $invoice1->delete();
        $invoice2->delete();
        $invoice3->delete();
    }

    public function test_send_not_paid()
    {
        //arrange
        $con = \Propel::getConnection();
        $invoice1 = new Invoice();
        $invoice1->setId('id1')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoice2 = new Invoice();
        $invoice2->setId('id2')->setCreateAfter(time() - 1)->setPaymentPaid(false)->save();
        $invoice3 = new Invoice();
        $invoice3->setId('id3')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoiceService = $this->getMockBuilder(MockAbstractInvoice::class)
            ->setMethods(array('sendOne'))
            ->getMockForAbstractClass();
        $invoiceService
            ->expects($this->at(0))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id1', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->at(1))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id3', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->exactly(2))
            ->method('sendOne');
        $now = new \DateTime();

        //act
        $invoiceService->send($now, $con);

        //assert
        $invoice1->delete();
        $invoice2->delete();
        $invoice3->delete();
    }


    public function test_send_not_greater_than_create_after()
    {
        //arrange
        $con = \Propel::getConnection();
        $invoice1 = new Invoice();
        $invoice1->setId('id1')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoice2 = new Invoice();
        $invoice2->setId('id2')->setCreateAfter(time() + 1000)->setPaymentPaid(true)->save();
        $invoice3 = new Invoice();
        $invoice3->setId('id3')->setCreateAfter(time() - 1)->setPaymentPaid(true)->save();
        $invoiceService = $this->getMockBuilder(MockAbstractInvoice::class)
            ->setMethods(array('sendOne'))
            ->getMockForAbstractClass();
        $invoiceService
            ->expects($this->at(0))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id1', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->at(1))
            ->method('sendOne')
            ->willReturnCallback(function(Invoice $invoice, \PropelPDO $conForTest = null) use($con){
                $this->assertEquals('id3', $invoice->getId());
                $this->assertSame($con, $conForTest);
            });
        $invoiceService
            ->expects($this->exactly(2))
            ->method('sendOne');
        $now = new \DateTime();

        //act
        $invoiceService->send($now, $con);

        //assert
        $invoice1->delete();
        $invoice2->delete();
        $invoice3->delete();
    }
}