<?php
namespace Widget\InvoiceBundle\Tests\Model;

use Backend\BaseBundle\Tests\Fixture\BaseTestCase;
use Widget\InvoiceBundle\Model\Invoice;
use Widget\InvoiceBundle\Model\InvoiceItem;

class InvoiceTest extends BaseTestCase
{
    public function test_syncTotalPrice()
    {
        //arrange
        $con = $this->getMockBuilder(\PropelPDO::class)
            ->disableOriginalConstructor()
            ->getMock();
        $invoiceItem1= new InvoiceItem();
        $invoiceItem1
            ->setUnitPrice(100)
            ->setQuantity(2);
        $invoiceItem2= new InvoiceItem();
        $invoiceItem2
            ->setUnitPrice(10)
            ->setQuantity(1);
        $invoiceItem3= new InvoiceItem();
        $invoiceItem3
            ->setUnitPrice(1000)
            ->setQuantity(3);
        $invoice = new Invoice();
        $invoice
            ->addInvoiceItem($invoiceItem1)
            ->addInvoiceItem($invoiceItem2)
            ->addInvoiceItem($invoiceItem3);

        //act
        $invoice->syncTotalPrice($con);

        //assert
        $this->assertEquals(3210, $invoice->getTotalPrice());
    }
}