<?php
namespace Widget\InvoiceBundle\Tests\Controller\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\InvoiceBundle\Service\InvoiceInterface;
use Widget\InvoiceBundle\Service\InvoiceValidator;
use Widget\InvoiceBundle\Service\OrderTokenInvoiceCreateRequest;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\MemberBundle\Token\MemberTokenRequest;
use Widget\OrderBundle\Model\OrderQuery;
use Widget\OrderBundle\Token\OrderTokenRequest;

class InvoiceControllerTest extends BaseWebTestCase
{
    public function test_createInvoiceAction_沒有_member_token()
    {
        //arrange
        $container = $this->client->getContainer();
        $tokenService = $container->get('token_service');
        $member = MemberQuery::create()->findOneByName('bubble0');
        $memberToken = $tokenService->sign(new MemberTokenRequest($member));
        $orderToken = $tokenService->sign(new OrderTokenRequest(OrderQuery::create()->findPk('P0000')));

        $data = array(
            'order_token' => $orderToken,
            'invoice' => array(
                'email' => 'ricky@dgfactor.com',
                'mark' => 'e',
                'loveCode' => '54321',
                'carrierType' => '0',
                'carrierId' => 'test',
                'companyName' => 'test',
                'companyId' => '12345678',
                'buyerName' => 'test',
                'buyerAddress' => '台北市凱達格蘭大道1號',
                'buyerAddressZip' => '105',
            ),
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_invoice_api_invoice_createinvoice'),
            array(),
            array(),
            array(
//                'HTTP_AUTHORIZATION' => "Bearer $memberToken",
            ),
            json_encode($data)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_UNAUTHORIZED, $response->getStatusCode());
    }

    public function test_createInvoiceAction_錯誤的_order_token()
    {
        //arrange
        $container = $this->client->getContainer();
        $tokenService = $container->get('token_service');
        $member = MemberQuery::create()->findOneByName('bubble0');
        $memberToken = $tokenService->sign(new MemberTokenRequest($member));
        $orderToken = $tokenService->sign(new OrderTokenRequest(OrderQuery::create()->findPk('P0000')));

        $data = array(
            'order_token' => 'bad_token',
            'invoice' => array(
                'email' => 'ricky@dgfactor.com',
                'mark' => 'e',
                'loveCode' => '54321',
                'carrierType' => '0',
                'carrierId' => 'test',
                'companyName' => 'test',
                'companyId' => '12345678',
                'buyerName' => 'test',
                'buyerAddress' => '台北市凱達格蘭大道1號',
                'buyerAddressZip' => '105',
            ),
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_invoice_api_invoice_createinvoice'),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $memberToken",
            ),
            json_encode($data)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_FORBIDDEN, $response->getStatusCode());
    }

    public function test_createInvoiceAction_validator_驗證錯誤()
    {
        //arrange
        $container = $this->client->getContainer();
        $tokenService = $container->get('token_service');
        $member = MemberQuery::create()->findOneByName('bubble0');
        $memberToken = $tokenService->sign(new MemberTokenRequest($member));
        $orderToken = $tokenService->sign(new OrderTokenRequest(OrderQuery::create()->findPk('P0000')));

        $data = array(
            'order_token' => $orderToken,
            'invoice' => array(
                'email' => 'ricky@dgfactor.com',
                'mark' => 'e',
                'loveCode' => '54321',
                'carrierType' => '0',
                'carrierId' => 'test',
                'companyName' => 'test',
                'companyId' => '12345678',
                'buyerName' => 'test',
                'buyerAddress' => '台北市凱達格蘭大道1號',
                'buyerAddressZip' => '105',
            ),
        );
        $invoiceValidator = $this->getMockBuilder(InvoiceValidator::class)
            ->setMethods(array('validate'))
            ->getMock();

        $invoiceValidator
            ->expects($this->once())
            ->method('validate')
            ->willReturn(array('email' => 'bad email'));

        $container->set('invoice_validator', $invoiceValidator);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_invoice_api_invoice_createinvoice'),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $memberToken",
            ),
            json_encode($data)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertEquals(Response::HTTP_BAD_REQUEST, $response->getStatusCode());
    }

    public function test_createInvoiceAction_ok()
    {
        //arrange
        $container = $this->client->getContainer();
        $tokenService = $container->get('token_service');
        $member = MemberQuery::create()->findOneByName('bubble0');
        $memberToken = $tokenService->sign(new MemberTokenRequest($member));
        $orderToken = $tokenService->sign(new OrderTokenRequest(OrderQuery::create()->findPk('P0000')));

        $data = array(
            'order_token' => $orderToken,
            'invoice' => array(
                'email' => 'ricky@dgfactor.com',
                'mark' => 'e',
                'loveCode' => '54321',
                'carrierType' => '0',
                'carrierId' => 'test',
                'companyName' => 'test',
                'companyId' => '12345678',
                'buyerName' => 'test',
                'buyerAddress' => '台北市凱達格蘭大道1號',
                'buyerAddressZip' => '105',
            ),
        );
        $invoiceValidator = $this->getMockBuilder(InvoiceValidator::class)
            ->setMethods(array('validate'))
            ->getMock();

        $invoiceValidator
            ->expects($this->once())
            ->method('validate')
            ->willReturn(array());

        $container->set('invoice_validator', $invoiceValidator);

        $invoiceService = $this->getMockBuilder(InvoiceInterface::class)
            ->setMethods(array('createFromOrderToken'))
            ->getMockForAbstractClass();

        $invoiceService
            ->expects($this->once())
            ->method('createFromOrderToken')
            ->willReturnCallback(function(OrderTokenInvoiceCreateRequest $tokenInvoiceCreateRequest){

            });
        $container->set('widget_invoice.invoice', $invoiceService);

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_invoice_api_invoice_createinvoice'),
            array(),
            array(),
            array(
                'HTTP_AUTHORIZATION' => "Bearer $memberToken",
            ),
            json_encode($data)
        );
        $response = $this->client->getResponse();

        //assert
        $this->assertTrue($response->isOk());
    }
}