<?php
namespace Widget\InvoiceBundle\Service;


use Backend\BaseBundle\Token\Service\Token;
use Widget\InvoiceBundle\Model\InvoicePeer;
use Widget\OrderBundle\Token\OrderTokenRequest;

class OrderTokenInvoiceCreateRequest implements InvoiceCreateRequestInterface
{

    /** @var Token  */
    protected $token;
    protected $invoiceInfo;

    public function __construct(Token $token, $invoiceInfo)
    {
        if(!$token->isType(OrderTokenRequest::TOKEN_TYPE)){
            throw new \RuntimeException("Token type must be an order token");
        }

        $this->token = $token;
        $this->invoiceInfo = $invoiceInfo;
    }

    public function getOrderInfo()
    {
        return $this->token->getData()['order'];
    }

    public function getId()
    {
        return $this->token->getId();
    }

    public function getEmail()
    {
        return $this->invoiceInfo['email']??null;
    }

    public function getDonateMark()
    {
        $map = array(
            'e' => InvoicePeer::DONATE_MARK_CARRIER,
            'd' => InvoicePeer::DONATE_MARK_DONATE,
            'p' => InvoicePeer::DONATE_MARK_PAPER,
         );

        $mark = $this->invoiceInfo['mark']??'e';
        return $map[$mark]??InvoicePeer::DONATE_MARK_CARRIER;
    }

    public function getCarrierType()
    {
        //invoice 手機條碼則:3J0002, 自然人憑證:CQ0001
        $map = array(
            '',
            '3J0002',
            'CQ0001',
        );
        $carrierType = $this->invoiceInfo['carrierType']??0;
        return $map[$carrierType]??'';
    }

    public function getCarrierId()
    {
        return $this->invoiceInfo['carrierId']??'';
    }

    public function getLoveCode()
    {
        return $this->invoiceInfo['loveCode']??'';
    }

    public function getIdentifier()
    {
        return $this->invoiceInfo['companyId']??'';
    }

    public function getName()
    {
        return $this->invoiceInfo['companyName']??'';
    }

    public function getZip()
    {
        return $this->invoiceInfo['buyerZip']??'';
    }

    public function getAddress()
    {
        return $this->invoiceInfo['buyerAddress']??'';
    }

}