<?php

namespace Widget\InvoiceBundle\Service;

use Widget\InvoiceBundle\Model\Invoice;
use Widget\InvoiceBundle\Model\InvoiceAllowance;
use Widget\OrderBundle\Token\OrderTokenRequest;

interface InvoiceInterface
{
    public function create($id, $email, $donateMark, $carrierType, $carrierId = null, $loveCode = null, $identifier = null, $name = null, $zip = null, $address = null, \PropelPDO $con = null);
    public function createFromOrderToken(OrderTokenInvoiceCreateRequest $invoiceCreateRequest, \PropelPDO $con = null);
    public function send(\DateTime $createAfter, \PropelPDO $con = null);
    public function sendOne(Invoice $invoice, \PropelPDO $con = null);
    public function createAllowance(Invoice $invoice, $reason, \PropelPDO $con = null);
    public function sendAllowance(InvoiceAllowance $invoiceAllowance, \PropelPDO $con = null);
}