<?php

namespace Widget\InvoiceBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\InvoiceBundle\Model\Invoice;
use Widget\InvoiceBundle\Model\InvoiceAllowance;

/**
 * @DI\Service("widget_invoice.invoice.cetustek")
 */
class CetustekInvoice extends AbstractInvoice
{
    const API_TYPE = "Cetustek";

    protected $config;

    /** @var  \SoapClient */
    protected $soapClient;

    /**
     * @DI\InjectParams({
     *     "config" = @DI\Inject("widget_invoice.config")
     * })
     */
    public function injectConfig($config)
    {
        $this->config = (isset($config[static::API_TYPE])?$config[static::API_TYPE]:array());
        try {
            $this->initSoapClient($this->config['gateway_url']);
        }
        catch (\Exception $e){
        }
    }

    protected function initSoapClient($gatewayUrl)
    {
        $this->soapClient = new \SoapClient($gatewayUrl);
    }

    protected function xmlToArray($xmlData)
    {
        $root =  @simplexml_load_string($xmlData);

        if($root === false){
            return false;
        }

        return array(
            $root->getName() => json_decode(json_encode($root), true),
        );
    }

    protected function arrayToXML($array, $withHeader = true, $preserveKey = null)
    {
        $output = '';
        foreach ($array as $key => $content) {
            if($preserveKey !== null){
                $key = $preserveKey;
            }
            if (!is_array($content)) {
                $output.="<$key>".htmlspecialchars($content)."</$key>";
            } else {
                if(array_keys($content) !== range(0, count($content) - 1)){
                    $output.="<$key>" . $this->arrayToXML($content, false) . "</$key>";
                }
                else{
                    $output.=$this->arrayToXML($content, false, $key);
                }
            }
        }
        if ($withHeader) {
            $output = '<?xml version="1.0" encoding="utf-8"?><Invoice XSDVersion="2.8">' . $output. "</Invoice>";
        }
        return $output;
    }

    public function sendOne(Invoice $invoice, \PropelPDO $con = null)
    {
        if(!$invoice->getPaymentPaid()){
            return false;
        }
        $result = $this->sendInvoice($invoice, $con);
        $invoice->save($con);
        return $result;
    }

    protected function sendInvoice(Invoice $invoice, \PropelPDO $con = null)
    {
        try {
            $productItems = array();
            foreach ($invoice->getInvoiceItems($con) as $invoiceItem){
                $productItems[] = array(
                    'ProductionCode' => $invoiceItem->getProductId(),
                    'Description' => $invoiceItem->getDescription(),
                    'Quantity' => $invoiceItem->getQuantity(),
                    'UnitPrice' => $invoiceItem->getUnitPrice(),
                    'Unit' => $invoiceItem->getUnit(),
                );
            }
            $array = array(
                'OrderId' => $invoice->getId(),
                'OrderDate' => strftime('%Y/%m/%d', time()),
                'BuyerIdentifier' => $invoice->getIdentifier(),
                'BuyerName' => $invoice->getName(),
                'BuyerAddress' => "{$invoice->getZip()} {$invoice->getAddress()}",
                'BuyerEmailAddress' => $invoice->getEmail(),
                'DonateMark' => $invoice->getDonateMark(),
                'InvoiceType' => $this->config['invoice_type'],
                'CarrierType' => $invoice->getCarrierType(),
                'CarrierId1' => $invoice->getCarrierId(),
                'CarrierId2' => $invoice->getCarrierId(),
                'NPOBAN' => $invoice->getLoveCode(),
                'PayWay' => $invoice->getPayway(),
                'TaxType' => 1,
                'TaxRate' => '0.05',
                'Remark' => $invoice->getRemark(),
                'Details' => array(
                    'ProductItem' => $productItems,
                ),
            );

            $result = $this->soapClient->CreateInvoiceV3(array(
                'invoicexml' => $this->arrayToXML($array),
                'hastax' => 1,
                'rentid' => $this->config['rentid'],
            ));

            $invoice->setApiResponse(json_encode($result));
            $invoice->setProcessAt(time());

            if (strlen($result->return) == 10) {
                $invoice->setInvoiceNumber($result->return);
                return true;
            }
        }
        catch (\Exception $e){
        }
        return false;
    }

    /**
     * 發出折讓單
     */
    public function sendAllowance(InvoiceAllowance $invoiceAllowance, \PropelPDO $con = null)
    {
        if($invoiceAllowance->getIsProcess()){
            return false;
        }
        $result = $this->sendInvoiceAllowance($invoiceAllowance, $con);
        $invoiceAllowance->save($con);
        return $result;
    }

    protected function sendInvoiceAllowance(InvoiceAllowance $invoiceAllowance, \PropelPDO $con = null)
    {
        try {
            $productItems = array();
            foreach ($invoiceAllowance->getInvoice()->getInvoiceItems($con) as $invoiceItem){
                $productItems[] = array(
                    'ProductionCode' => $invoiceItem->getProductId(),
                    'Description' => $invoiceItem->getDescription(),
                    'Quantity' => $invoiceItem->getQuantity(),
                    'UnitPrice' => $invoiceItem->getUnitPrice(),
                    'Unit' => $invoiceItem->getUnit(),
                );
            }
            $array = array(
                'AllowanceNumber' => $invoiceAllowance->getId(),
                'AllowanceDate' => strftime('%Y/%m/%d', time()),
                'InvoiceNumber' => $invoiceAllowance->getInvoice()->getInvoiceNumber(),
                'InvoiceYear' => $invoiceAllowance->getInvoice($con)->getProcessAt('%Y'),
                'TaxType' => 1,
                'Reason' => $invoiceAllowance->getReason(),
                'Details' => array(
                    'ProductItem' => $productItems,
                ),
            );

            $result = $this->soapClient->CreateAllowance(array(
                'allowancexml' => $this->arrayToXML($array),
                'checkallowance' => 0,
                'rentid' => $this->config['rentid'],
            ));

            $invoiceAllowance->setApiResponse(json_encode($result));
            $invoiceAllowance->setProcessAt(time());

            if ($result->return == 'A0') {
                $invoiceAllowance->setIsProcess(true);
                return true;
            }
        }
        catch (\Exception $e){
        }
        return false;
    }

}