<?php
namespace Widget\InvoiceBundle\Service;

use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Widget\InvoiceBundle\Event\GetInvoiceItemEvent;
use Widget\InvoiceBundle\Model\Invoice;
use Widget\InvoiceBundle\Model\InvoiceAllowance;
use Widget\InvoiceBundle\Model\InvoiceItem;
use Widget\InvoiceBundle\Model\InvoicePeer;
use Widget\InvoiceBundle\Model\InvoiceQuery;

abstract class AbstractInvoice implements InvoiceInterface
{
    const API_TYPE = "";

    /** @var  EventDispatcherInterface */
    protected $eventDispatcher;
    protected $config = array();

    /**
     * @param EventDispatcherInterface $eventDispatcher
     * @DI\InjectParams()
     */
    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher)
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    public function createFromOrderToken(OrderTokenInvoiceCreateRequest $invoiceCreateRequest, \PropelPDO $con = null)
    {
        $createAfter = (int)($this->config['create_after']??0);
        $invoice = new Invoice();
        $invoice
            ->setId($invoiceCreateRequest->getId())
            ->setEmail($invoiceCreateRequest->getEmail())
            ->setDonateMark($invoiceCreateRequest->getDonateMark())
            ->setCarrierType($invoiceCreateRequest->getCarrierType())
            ->setCarrierId($invoiceCreateRequest->getCarrierId())
            ->setLoveCode($invoiceCreateRequest->getLoveCode())
            ->setIdentifier($invoiceCreateRequest->getIdentifier())
            ->setName($invoiceCreateRequest->getName())
            ->setZip($invoiceCreateRequest->getZip())
            ->setAddress($invoiceCreateRequest->getAddress())
            ->setApiType(static::API_TYPE)
            ->setCreateAfter(new \DateTime("+$createAfter day"))
        ;
        $orderInfo = $invoiceCreateRequest->getOrderInfo();
        foreach($orderInfo['items'] as $item){
            $invoiceItem = new InvoiceItem();
            $invoiceItem
                ->setInvoice($invoice)
                ->setProductId($item['id'])
                ->setDescription($item['name'])
                ->setQuantity($item['count'])
                ->setUnitPrice($item['price'])
                ->setUnit($item['unit']);
        }
        $invoice->syncTotalPrice($con)->save($con);
        return $invoice;
    }

    public function create($id, $email, $donateMark, $carrierType, $carrierId = null, $loveCode = null, $identifier = null, $name = null, $zip = null, $address = null, \PropelPDO $con = null)
    {
        $createAfter = (int)($this->config['create_after']??0);
        $invoice = new Invoice();
        $invoice
            ->setId($id)
            ->setEmail($email)
            ->setDonateMark($donateMark)
            ->setCarrierType($carrierType)
            ->setCarrierId($carrierId)
            ->setLoveCode($loveCode)
            ->setIdentifier($identifier)
            ->setName($name)
            ->setZip($zip)
            ->setAddress($address)
            ->setApiType(static::API_TYPE)
            ->setCreateAfter(new \DateTime("+$createAfter day"))
        ;
        $event = new GetInvoiceItemEvent($invoice, $con);
        $this->eventDispatcher->dispatch(GetInvoiceItemEvent::EVENT_NAME, $event);
        $invoice->syncTotalPrice($con)->save($con);
        return $invoice;
    }

    /**
     * 建立發票折讓DB
     */
    public function createAllowance(Invoice $invoice, $reason, \PropelPDO $con = null)
    {
        if(!$invoice->getPaymentPaid()){
            return false;
        }
        $invoiceAllowance = new InvoiceAllowance();
        $invoiceAllowance
            ->setId($invoice->getId())
            ->setReason($reason)
            ->save($con)
        ;
        return $invoiceAllowance;
    }

    public function send(\DateTime $createAfter, \PropelPDO $con = null)
    {
        $invoices = InvoiceQuery::create()
            ->filterByCreateAfter($createAfter, \Criteria::LESS_THAN)
            ->filterByProcessAt(null, \Criteria::ISNULL)
            ->filterByPaymentPaid(true)
            ->find($con);
        foreach ($invoices as $invoice){
            $this->sendOne($invoice, $con);
        }
    }

}