module.exports = {
    "list": {
        "id": {
            "type": "text",
            "label": "fields.invoice.id",
            "sort": true,
            "search": true,
            "searchConfig": {
                "type": "text",
                "key": "id",
                "like": true
            }
        },
        "invoice_number": {
            "type": "text",
            "label": "fields.invoice.invoice_number",
            "search": true,
            "searchConfig": {
                "type": "text",
                "key": "invoice_number",
                "like": true
            }
        },
        "identifier": {
            "type": "text",
            "label": "fields.invoice.identifier",
            "search": true,
            "searchConfig": {
                "type": "text",
                "key": "identifier",
                "like": true
            }
        },
        "email": {
            "type": "text",
            "label": "fields.invoice.email",
            "search": true,
            "searchConfig": {
                "type": "text",
                "key": "email",
                "like": true
            }
        },
        "total_price": {
            "type": "text",
            "label": "fields.invoice.total_price"
        },
        "create_after": {
            "type": "datetime-local",
            "label": "fields.invoice.create_after",
            "sort": true,
            "search": true,
            searchConfig:
                key: "create_after"
                type: "daterange"
        },
        "process_at": {
            "type": "datetime-local",
            "label": "fields.invoice.process_at",
            "sort": true,
            "search": true,
            searchConfig:
                key: "process_at"
                type: "daterange"
        },
        "created_at": {
            "type": "datetime-local",
            "label": "fields.invoice.created_at",
            "sort": true,
            "search": true,
            searchConfig:
                key: "created_at"
                type: "daterange"
            "defaultSorting": "desc"
        }
    },
    "customBatch": [
        {
            "label": "batch.button.reset_invoice_process",
            "roles": ["ROLE_INVOICE_WRITE"],
            component: require 'components/widgetinvoice/customize/list/actions/reset_process.vue'
        },
    ],
    "extra": [],
    "action": [
        {
            "name": "view",
            "label": "action.view",
            "route": "invoice-view",
            "roles": [
                "ROLE_INVOICE_READ"
            ]
        }
        {
            "name": "edit"
            "label": "action.edit"
            "roles": ["ROLE_INVOICE_WRITE"]
            "route": 'invoice-edit'
        }
    ]
}