<?php
namespace Widget\InvoiceBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\InvoiceBundle\Model\InvoicePeer;
use Widget\InvoiceBundle\Model\InvoiceQuery;
use Widget\PaymentBundle\Event\UpdatePaymentTypeEvent;

/**
 * @DI\Service()
 */
class UpdatePaymentTypeListener
{
    /**
     * @DI\Observe(UpdatePaymentTypeEvent::EVENT_NAME)
     */
    public function onUpdatePaymentType(UpdatePaymentTypeEvent $event)
    {
        $paymentType = $event->getPaymentType();

        if(!($invoice = InvoiceQuery::create()->findPk($event->getOrdernumber()))){
            return;
        }

        $invoice->setPayway($this->convertPaymentType($paymentType))->save();
    }

    protected function convertPaymentType($paymentType)
    {
        if(preg_match('/cash/i', $paymentType, $match)){
            return InvoicePeer::PAYWAY_CASH;
        }
        if(preg_match('/vacc/i', $paymentType, $match)){
            return InvoicePeer::PAYWAY_ATM;
        }
        if(preg_match('/credit/i', $paymentType, $match)){
            return InvoicePeer::PAYWAY_CREDIT;
        }
        if(preg_match('/cvs/i', $paymentType, $match)){
            return InvoicePeer::PAYWAY_CONVIENT;
        }
        return InvoicePeer::PAYWAY_OTHER;
    }
}