<?php
namespace Widget\InvoiceBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\InvoiceBundle\Model\InvoiceQuery;
use Widget\PaymentBundle\Event\ReceiveOrderEvent;

/**
 * @DI\Service()
 */
class ReceiveOrderListener
{
    /**
     * @DI\Observe("event.widget.payment.receive.order", priority=512)
     */
    public function onReceiveOrder(ReceiveOrderEvent $event)
    {
        if(!($invoice = InvoiceQuery::create()->findPk($event->getOrdernumber()))){
            return;
        }

        $invoice->setPaymentPaid($event->getStatus())->save();
    }
}