<?php
namespace Widget\InvoiceBundle\EventListener;

use Backend\BaseBundle\Event\DynamicCustomConfigEvent;
use JMS\DiExtraBundle\Annotation as DI;
use Widget\InvoiceBundle\Service\InvoiceInterface;

/**
 * @DI\Service()
 */
class AdminDumpListener
{
    /** @var  InvoiceInterface */
    protected $invoiceService;

    /**
     * @DI\InjectParams({
     *   "invoiceService" = @DI\Inject("widget_invoice.invoice")
     * })
     */
    public function injectInvoiceService(InvoiceInterface $invoiceService)
    {
        $this->invoiceService = $invoiceService;
    }

    /**
     * @DI\Observe(DynamicCustomConfigEvent::EVENT_NAME)
     */
    public function onDynamicCustomConfig(DynamicCustomConfigEvent $event)
    {
        if($event->getBundleName() != 'WidgetInvoiceBundle'){
            return;
        }
        $this->dumpSubmodule($event->getTargetDir());
    }

    protected function dumpSubmodule($targetDir)
    {
        $class = get_class($this->invoiceService);
        $config = array(
            'submodule' => $class::API_TYPE,
        );
        file_put_contents("$targetDir/config/submodule.json", json_encode($config, JSON_PRETTY_PRINT));
    }
}