<?php
namespace Widget\InvoiceBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\InvoiceBundle\Model\Invoice;

class GetInvoiceItemEvent extends Event
{
    const EVENT_NAME = 'event.get_invoice_item';

    /** @var Invoice  */
    protected $invoice;
    /** @var \PropelPDO  */
    protected $con;

    public function __construct(Invoice $invoice, \PropelPDO $con = null)
    {
        $this->invoice = $invoice;
        $this->con = $con;
    }

    /**
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * @return \PropelPDO
     */
    public function getCon()
    {
        return $this->con;
    }
}