<?php
namespace Widget\InvoiceBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Backend\BaseBundle\Token\Service\Token;
use Backend\BaseBundle\Token\Service\TokenServiceInterface;
use JMS\DiExtraBundle\Annotation as DI;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\InvoiceBundle\Service\InvoiceInterface;
use Widget\InvoiceBundle\Service\InvoiceValidator;
use Widget\InvoiceBundle\Service\OrderTokenInvoiceCreateRequest;
use Widget\OrderBundle\Token\OrderTokenRequest;

class InvoiceController extends BaseController
{
    /**
     * @var TokenServiceInterface
     * @DI\Inject()
     */
    protected $tokenService;

    /**
     * @var InvoiceInterface
     * @DI\Inject("widget_invoice.invoice")
     */
    protected $invoiceService;

    /**
     * @var InvoiceValidator
     * @DI\Inject()
     */
    protected $invoiceValidator;

    /**
     * 建立發票
     * @Route("/invoices")
     * @Method({"POST"})
     */
    public function createInvoiceAction(Request $request)
    {
        /** @var $token Token */
        if(!(($token = $request->attributes->get('_authorizedToken')) instanceof Token)){
            return $this->createHttpExceptionResponse(Response::HTTP_UNAUTHORIZED);
        }

        $requestBody = json_decode($request->getContent(), true);
        $orderToken = $this->tokenService->parse($requestBody['order_token']??null);
        $invoiceInfo = $requestBody['invoice']??null;

        if(!$orderToken || !$orderToken->isType(OrderTokenRequest::TOKEN_TYPE)){
            return $this->createHttpExceptionResponse(Response::HTTP_FORBIDDEN);
        }

        $result = $this->invoiceValidator->validate($invoiceInfo);

        if(count($result)){
            return $this->createJsonResponse($result,Response::HTTP_BAD_REQUEST);
        }

        $this->invoiceService->createFromOrderToken(new OrderTokenInvoiceCreateRequest($orderToken, $invoiceInfo));
        return $this->createJsonResponse();
    }
}