<?php
namespace Widget\InvoiceBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class BatchSendCommand extends ContainerAwareCommand
{
    /**
     * @see Command
     */
    protected function configure()
    {
        $this
            ->setName('dgfactor:invoice:batch')
            ->setDescription('批次送出發票訊息')
            ->setHelp(<<<EOT
<info>dgfactor:invoice:batch</info> 批次送出發票訊息.
EOT
            );
    }

    /**
     * @see Command
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $container = $this->getContainer();
        $invoiceService = $container->get('widget_invoice.invoice');
        $now = new \DateTime();
        $invoiceService->send($now);
    }
}
