<?php

namespace Widget\DiscountBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\DiscountBundle\EventListener\DiscountListener;
use Widget\DiscountBundle\Service\DiscountBuilder;
use Widget\OrderBundle\Event\DiscountModulesEvent;
use Widget\OrderBundle\Model\Order;

class DiscountListenerTest extends BaseWebTestCase
{
    public function test_discountBuilder()
    {
        // arrange
        $order = new Order();
        $con = $this->getMockBuilder(\PropelPDO::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $discountListener = $this->getMockBuilder(DiscountListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = new DiscountModulesEvent($order, $con);

        $discountBuilder = $this->getMockBuilder(DiscountBuilder::class)
            ->disableOriginalConstructor()
            ->setMethods(array('init', 'run'))
            ->getMock();
        $discountBuilder
            ->expects($this->once())
            ->method('init')
            ->willReturnCallback(function($orderForTest, $conForTest) use($order, $con){
                $this->assertEquals($order, $orderForTest);
                $this->assertEquals($con, $conForTest);
            });

        $discountBuilder
            ->expects($this->once())
            ->method('run')
            ->willReturnCallback(function($orderForTest, $conForTest) use($order, $con){
                $this->assertEquals($order, $orderForTest);
                $this->assertEquals($con, $conForTest);
            });

        $this->setObjectAttribute($discountListener, 'discountBuilder', $discountBuilder);
        // act
        $discountListener->discountBuilder($event);

        // assert
    }
}