<?php

namespace Widget\DiscountBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Propel\I18n;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\DiscountBundle\Model\DiscountGroup;
use Widget\DiscountBundle\Model\DiscountGroupI18nQuery;
use Widget\DiscountBundle\Model\DiscountGroupQuery;

class DiscountGroupControllerTest extends BackendWebTestCase
{
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $params = array(
            'name' => '新優會群組',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_discount_backendapi_discountgroup_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $result = json_decode($response->getContent(), true);

        //assert
        $discountGroup = DiscountGroupQuery::create()->findOneById($result['id']);
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $discountGroup->getName());

        $discountGroup->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'name' => 'asc'
            ),
            'search' => array(
                'name' => '%優惠%',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_backendapi_discountgroup_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('name', $responseArray['data'][0]);
    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $discountGroupName = "優惠群組1";
        $query = DiscountGroupQuery::create();
        if ($query instanceof I18n){
            $discountGroup = DiscountGroupI18nQuery::create()
                ->findOneByName($discountGroupName);
        }else {
            $discountGroup = $query->findOneByName($discountGroupName);
        }

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_backendapi_discountgroup_read', array('id' => $discountGroup->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);
        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($discountGroupName, $responseArray['name']);
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $discountGroupName = "優惠群組1";
        $query = DiscountGroupQuery::create();
        if ($query instanceof I18n){
            $discountGroup = DiscountGroupI18nQuery::create()
                ->findOneByName($discountGroupName);
        }else {
            $discountGroup = $query->findOneByName($discountGroupName);
        }
        $params = array(
            'name' => '改過的優惠群組'
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_discount_backendapi_discountgroup_update', array('id' => $discountGroup->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $responseArray['name']);

        $reSetDiscountGroup = DiscountGroupQuery::create()->findOneById($responseArray['id']);
        $reSetDiscountGroup->setName($discountGroupName);
        $reSetDiscountGroup->save();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $id = 3;
        $originDiscountGroup = DiscountGroupQuery::create()->findOneById($id)->toArray();


        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_discount_backendapi_discountgroup_delete', array('id' => $id)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        //assert
        $discountGroupQuery = DiscountGroupQuery::create()->findOneById('會被刪掉');

        $this->assertTrue($response->isOk());
        $this->assertNull($discountGroupQuery);
        $discountGroup = new DiscountGroup();
        $discountGroup->fromArray($originDiscountGroup);
        $discountGroup->save();
    }
}