<?php

namespace Widget\DiscountBundle\Service\Discount;

abstract class AbstractDiscount implements DiscountInterface
{
    protected $processed = false;
    protected $config;
    protected $siteId;

    public static function create($config)
    {
        return new static($config);
    }

    protected function __construct($config)
    {
        $this->injectConfig($config);
    }

    public function injectSiteId($siteId)
    {
        $this->siteId = $siteId;
        return $this;
    }

    public function injectConfig($config)
    {
        $this->config = $config;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isProcessed()
    {
        return $this->processed;
    }
}