module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "name": {
      "label": "index.discountgroup.name",
      "type": "text",
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "created_at": {
      "label": "index.discountgroup.created_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "updated_at": {
      "label": "index.discountgroup.updated_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_DISCOUNTGROUP_WRITE"]
      "route": 'discountgroup-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_DISCOUNTGROUP_WRITE"]
      "route": 'discountgroup-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_DISCOUNTGROUP_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}