module.exports = (api) ->
  api.discountgroup =
    search: (data) ->
      api.request "GET", "/discountgroups", data
    create: (data) ->
      api.request "POST", "/discountgroups", data
    read: (id) ->
      api.request "GET", "/discountgroup/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/discountgroup/#{id}", data
    delete: (id) ->
      api.request  "DELETE", "/discountgroup/#{id}"
    batch: (ids, action, column) ->
      api.request  "PUT", "/discountgroups",
        ids: ids
        action: action
        column: column
    relate: (id, data) ->
      api.request "POST", "/discountgroup/#{id}/discounttogroup", data
    relateExclude: (id, data) ->
      api.request "POST", "/discountgroup/#{id}/discounttogroup/exclude", data      
    discountModules: () ->
      api.request "GET", "/discountmodules/all"
        