<?php

namespace Widget\DiscountBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\DiscountBundle\Service\DiscountBuilder;
use Widget\OrderBundle\Event\DiscountModulesEvent;

/**
 * @DI\Service()
 */
class DiscountListener
{
    /**
     * @DI\Inject("widget.discount_bundle.discount_builder")
     * @var DiscountBuilder
     */
    public $discountBuilder;
    
    /**
     * @DI\Observe(DiscountModulesEvent::EVENT_NAME)
     */
    public function discountBuilder(DiscountModulesEvent $event)
    {
        $order = $event->getOrder();
        $con = $event->getCon();
        $parameters = $event->getParameters();
        $this->discountBuilder->init($order, $con, $parameters);
        $this->discountBuilder->run($order, $con);
    }
}