<?php

namespace Widget\DiscountBundle\Event;


use Symfony\Component\EventDispatcher\Event;

class DiscountFactoryEvent extends Event
{
    const EVENT_NAME = 'event.discount.factory';
    
    protected $module;
    
    protected $object = null;
    
    protected $parameters;
    
    public function __construct($module, $parameters = array())
    {
        $this->module = $module;
        $this->parameters = $parameters;
    }

    /**
     * @return mixed
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * @param mixed $object
     */
    public function setObject($object)
    {
        $this->object = $object;
    }

    /**
     * @return mixed
     */
    public function getModule()
    {
        return $this->module;
    }

    /**
     * @return array
     */
    public function getParameters()
    {
        return $this->parameters;
    }
}