<?php

namespace Widget\DiscountBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\GreaterThan;
use Symfony\Component\Validator\Constraints\NotBlank;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\DiscountBundle\Model\DiscountModulePeer;
use Widget\DiscountBundle\Model\DiscountModuleQuery;

/**
 * @Route("/discountmodule")
 * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE')")
 */
class DiscountModuleController extends BaseBackendAPIController
{
    /**
     * 欄位表單設定
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            new APIFormTypeItem('name'),
            new APIFormTypeItem('class_name'),
            (new APIFormTypeItem('sort'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.discountmodule.sort.missing_field',
                    )),
                    new GreaterThan(array(
                        'value' => -1,
                        'message' => "error.discountmodule.greater_than_negative",
                    ))
                )
            )),
            new APIFormTypeItem('config'),
            new APIFormTypeItem('start_at'),
            new APIFormTypeItem('stop_at'),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_WRITE')")
     */
    public function createAction(Request $request)
    {
        // 抽離出來做（同樣）動作 參數： 物件、content
        return $this->doProcessForm(new DiscountModule(), $request->getContent());
    }

    /**
     * 搜尋
     * @Route("s")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_READ')")
     */
    public function searchAction(Request $request)
    {
        return $this->doSearch($request->query->all(), DiscountModuleQuery::create()->distinct(), DiscountModulePeer::class);
    }

    /**
     * 讀取
     * @Route("/{id}")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_READ')")
     */
    public function readAction(DiscountModule $discountModule)
    {
        return $this->createJsonSerializeResponse($discountModule, array('detail'));
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_WRITE')")
     */
    public function updateAction(Request $request, DiscountModule $discountModule)
    {
        return $this->doProcessForm($discountModule, $request->getContent());
    }

    /**
     * 刪除
     * @Route("/{id}")
     * @Method({"DELETE"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_WRITE')")
     */
    public function deleteAction(DiscountModule $discountModule)
    {
        $this->deleteObject($discountModule);
        return $this->createJsonResponse();
    }

    /**
     * @Route("s/all")
     * @Method({"GET"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNTMODULE_WRITE')")
     */
    public function allAction(Request $request)
    {
        $discountModules = DiscountModuleQuery::create()->find();
        return $this->createJsonSerializeResponse($discountModules, array('list'));
    }
}