<?php

namespace Widget\DiscountBundle\EventListener\ControllerConfig;

use Backend\BaseBundle\Event\Controller\ConfigEvent;
use Backend\BaseBundle\Event\Controller\MenuEvent;
use Backend\BaseBundle\Event\Controller\TypeRolesEvent;
use Backend\BaseBundle\Form\Type\RelationType;
use Backend\BaseBundle\Form\Type\SubmitBackType;
use Backend\BaseBundle\Service\FunctionCheckerServiceInterface;
use JMS\DiExtraBundle\Annotation as DI;
use JMS\DiExtraBundle\Annotation\Inject;
use JMS\DiExtraBundle\Annotation\Observe;
use JMS\DiExtraBundle\Annotation\Service;
use JMS\DiExtraBundle\Annotation\InjectParams;
use PropelObjectCollection;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Routing\Router;
use Symfony\Component\Validator\Constraints\Callback;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Widget\DiscountBundle\Model\DiscountGroup;
use Widget\DiscountBundle\Model\DiscountGroupQuery;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\DiscountBundle\Model\DiscountModuleQuery;
use Widget\MemberBundle\Event\RequestDiscountConfigEvent;
use Widget\MemberBundle\Model\Member;

/**
 * @Service()
 */
class DiscountGroupListener
{
    const CONTROLLER_NAME = 'WidgetDiscountBundle:Backend/DiscountGroup';

    /** @var  Router */
    protected $router;

    /** @var  FunctionCheckerServiceInterface */
    protected $functionChecker;    
    
    /**
     * @InjectParams()
     */
    public function injectRouter(Router $router)
    {
        $this->router = $router;
    }

    /**
     * @InjectParams({
     *    "functionChecker" = @Inject("site.function.checker")
     * })
     */
    public function injectService(FunctionCheckerServiceInterface $functionChecker)
    {
        $this->functionChecker = $functionChecker;
    }


    /**
     * 注入選單服務
     * @Observe(MenuEvent::EVENT_MENU)
     */
    public function onMenu(MenuEvent $event)
    {
        $isActive = preg_match('/^widget_discount_backend_discountgroup_/i', $event->getRequestRouteName());
        $user = $event->getUser();
        if(!$user->hasRoleOrSuperAdmin('ROLE_GROUP_READ')) {
            return;
        }
        $slug = $user->getSiteSlug();
        $event->addMenu(self::CONTROLLER_NAME, array(
            'menu.discount_group' => array(
                'class' => 'fa fa-money',
                'active' => $isActive,
                'target' => array(
                    'menu.discount_group_list' => array(
                        'class' => 'fa fa-users',
                        'active' => $isActive,
                        'target' => $this->router->generate('widget_discount_backend_discountgroup_index', array('slug' => $slug)),
                    ),
                ),
            ),
        ));
    }

    /**
     * 讓帳號管理介面加入權限設定
     * @Observe(TypeRolesEvent::EVENT_TYPE_ROLES)
     */
    public function onTypeRoles(TypeRolesEvent $event)
    {
        $event->addTypeRoles('ROLE_MEMBER', array(
            'ROLE_GROUP_READ',
            'ROLE_GROUP_WRITE',
        ));
    }

    /**
     * @Observe(ConfigEvent::EVENT_CONFIG)
     */
    public function onConfig(ConfigEvent $event)
    {
        if($event->getControllerName() != self::CONTROLLER_NAME){
            return;
        }
        if (preg_match('/edit/', $_SERVER['REQUEST_URI'])) {
            $id = explode("/", $_SERVER['REQUEST_URI'])[4];
        }
        else {
            $id = null;
        }
        $event->stopPropagation();
        $event->setConfig(array(
            'route' => array(
                'sort' => true,
                'index' => true,
                'edit' => true,
                'new' => true,
                'delete' => true,
                'search' => true,
            ),
            'index' => array(
                '＃' => 'Id',
                'index.discountgroup.name' => 'Name',
                'index.discountgroup.created_at' => 'CreatedAt',
            ),
            'security' => array(
                'new' =>  'ROLE_GROUP_WRITE',
                'edit' => 'ROLE_GROUP_WRITE',
                'delete' => 'ROLE_GROUP_WRITE',
            ),
            'action' => array(
                'action.edit' => array(
                    'class' => 'fa fa-pencil-square-o',
                    'action' => 'edit'
                ),
                'action.delete' => array(
                    'class' => 'fa fa-trash',
                    'action' => 'delete',
                    'confirm' => 'message.confirm.delete',
                ),
            ),
            'search' => array(
                array(
                    'Name',
                    TextType::class,
                    array(
                        'label' => 'index.discountgroup.name',
                        'required' => false,
                    ),
                ),
            ),
            'form' => array(
                array(
                    'Name',
                    TextType::class,
                    array(
                        'label' => 'index.discountgroup.name',
                        'required' => true,
                    ),
                ),
                array(
                    'DiscountModules',
                    RelationType::class,
                    array(
                        'label' => 'index.discountgroup.moudles',
                        'class' => DiscountModule::class,
                        'multiple' => true,
                        'required' => false,
                        'data' => DiscountModuleQuery::create()
                            ->useDiscountToGroupQuery()
                            ->filterByGroupId($id)
                            ->filterByExclude(false)
                            ->endUse()
                            ->find()
                    ),
                ),
                array(
                    'submit',
                    SubmitBackType::class,
                    array(
                        'with_back' => true,
                        'with_reset' => true,
                        'back_route' => 'widget_discount_backend_discountgroup_index',
                    ),
                ),
            ),
        ));
    }

    /**
     * @DI\Observe(RequestDiscountConfigEvent::EVENT_NAME)
     */
    public function onDiscountModel(RequestDiscountConfigEvent $event)
    {
        $event->stopPropagation();
        $event->setViewConfig($this->onPaymentViewConfig());
    }

    public function onPaymentViewConfig()
    {
        return array(
            array(
                'DiscountGroups',
                RelationType::class,
                array(
                    'label' => 'form.label.edit.groupdiscount.members',
                    'class' => DiscountGroup::class,
                    'multiple' => true,
                    'required' => false,
                    'constraints' => array(
                        new Callback(function(PropelObjectCollection $value, ExecutionContextInterface $context){
                            if($value->count() > 1) {
                                $context->addViolation('error.discount.discount_groups.only');
                            }
                        }),
                    )
                ),
            )
        );
    }
}