<?php

namespace Widget\DiscountBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Widget\DiscountBundle\Service\DiscountBuilder;

class DiscountChainsEvent extends Event
{
    const EVENT_NAME = 'event.discount.chain';
    /**
     * @var DiscountBuilder
     */
    protected $discountBuilder;
    
    protected $siteId;

    public function __construct(DiscountBuilder $discountBuilder, $siteId)
    {
        $this->discountBuilder = $discountBuilder;
        $this->siteId = $siteId;
    }

    /**
     * @return DiscountBuilder
     */
    public function getDiscountBuilder()
    {
        return $this->discountBuilder;
    }

    /**
     * @return mixed
     */
    public function getSiteId()
    {
        return $this->siteId;
    }
}