<?php

namespace Widget\DiscountBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Widget\DiscountBundle\Model\DiscountGroup;
use Widget\DiscountBundle\Model\DiscountGroupQuery;
use Widget\DiscountBundle\Model\DiscountToGroup;

/**
 * @Route("/discountgroup")
 */
class DiscountGroupController extends BaseController
{
    public function updateData($form)
    {
        $id = explode("/", $_SERVER['REQUEST_URI'])[4];
        // 找出 group 互斥的關聯
        if ($id == "new") {
            parent::updateData($form);
            return;
        }
        $discountOriginGroup = DiscountGroupQuery::create()
            ->findPk($id);
        $originDiscountToGroups = $discountOriginGroup->getDiscountToGroups();
        /** @var DiscountToGroup $group */
        $excludeArray = array();
        foreach($originDiscountToGroups as $group) {
            if ($group->getExclude()) {
                $excludeArray[] = $group->getDiscountModuleId();
            }
        }
        
        parent::updateData($form);

        $afterUpdate = DiscountGroupQuery::create()
            ->useDiscountToGroupQuery()
            ->filterByExclude(false)
            ->endUse()
            ->findPk($id);
        /** @var DiscountToGroup $discountToGroup */
        $afterUpdateModuleArray = array();
        // 自動更新的關聯改成非互斥
        foreach($afterUpdate->getDiscountToGroups() as $discountToGroup){
            $afterUpdateModuleArray[] = $discountToGroup->getDiscountModuleId();
            $discountToGroup->setExclude(false);
            $discountToGroup->save();
        }

        // Update 前的互斥資料寫回去
        foreach($excludeArray as $moduleId){
            try {
                $discountToGroup = new DiscountToGroup();
                $discountToGroup->setDiscountModuleId($moduleId);
                $discountToGroup->setGroupId($id);
                $discountToGroup->setExclude(true);
                $discountToGroup->save();
            }
            catch (\Exception $e) {

            }
        }
    }
}