<?php

namespace Widget\DiscountBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Widget\DiscountBundle\Model\DiscountGroup;
use Widget\DiscountBundle\Model\DiscountGroupQuery;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\DiscountBundle\Model\DiscountToGroup;
use Widget\DiscountBundle\Model\DiscountToGroupQuery;

/**
 * @Route("/discountexludegroup")
 */
class DiscountExcludeGroupController extends BaseController
{
    public function updateData($form)
    {
        $id = explode("/", $_SERVER['REQUEST_URI'])[4];
        // 找出 group 互斥的關聯
        if ($id == "new") {
            /** @var DiscountGroup $discountGroup */
            $discountGroup = $form->getData();

            parent::updateData($form);
            /** @var DiscountToGroup $discountToGroup */
            foreach ($discountGroup->getDiscountToGroups() as $discountToGroup) {
                $discountToGroup->setExclude(true);
                $discountGroup->addDiscountToGroup($discountToGroup);
                $discountGroup->save();
            }
            return;
        }
        // 找出 group 非互斥的關聯
        $discountOriginGroup = DiscountGroupQuery::create()
            ->findPk($id);
        $originDiscountToGroups = $discountOriginGroup->getDiscountToGroups();
        /** @var DiscountToGroup $group */
        $notExcludeArray = array();
        foreach($originDiscountToGroups as $group) {
            if (!$group->getExclude()) {
                $notExcludeArray[] = $group->getDiscountModuleId();
            }
        }
        parent::updateData($form);
        $afterUpdate = DiscountGroupQuery::create()
            ->useDiscountToGroupQuery()
            ->filterByExclude(true)
            ->endUse()
            ->findPk($id);
        /** @var DiscountToGroup $discountToGroup */
        $afterUpdateModuleArray = array();
        // 自動更新的關聯改成互斥
        foreach($afterUpdate->getDiscountToGroups() as $discountToGroup){
            $afterUpdateModuleArray[] = $discountToGroup->getDiscountModuleId();
            $discountToGroup->setExclude(true);
            $discountToGroup->save();
        }

        // Update 前的非互斥資料寫回去
        foreach($notExcludeArray as $moduleId){
            try {
                $discountToGroup = new DiscountToGroup();
                $discountToGroup->setDiscountModuleId($moduleId);
                $discountToGroup->setGroupId($id);
                $discountToGroup->setExclude(false);
                $discountToGroup->save();
            }
            catch (\Exception $e) {

            }
        }
    }
}