<?php

namespace Widget\Discount\TargetAmountBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Discount\TargetAmountBundle\EventListener\TargetAmountListener;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\DiscountBundle\Model\DiscountModuleQuery;
use Widget\DiscountBundle\Service\Discount\DiscountInterface;

class TargetAmountListenerTest extends BaseWebTestCase
{
    public function test_factoryClass()
    {
        // arrange
        $targetAmountListener = $this->getMockBuilder(TargetAmountListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function(){
                return DiscountModuleQuery::create()->findPk(1)->toArray(\BasePeer::TYPE_FIELDNAME);
            });
        $event
            ->expects($this->once())
            ->method('setObject')
            ->willReturnCallback(function ($discountClassForTest){
                $this->assertInstanceOf(DiscountInterface::class, $discountClassForTest);
            });

        // act
        $targetAmountListener->factoryClass($event);
    }

    public function test_factoryClass_bad_class_name()
    {
        // arrange
        $targetAmountListener = $this->getMockBuilder(TargetAmountListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function(){
                return array('class_name' => '不符合的class_name');
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('應該不能call');
            });

        // act
        $targetAmountListener->factoryClass($event);
    }
}