<?php
namespace Widget\Discount\TargetAmountBundle\Discount;

use Widget\DiscountBundle\Service\Discount\AbstractDiscount;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;


class TargetAmountDiscount extends AbstractDiscount
{

    const CLASS_NAME = 'TargetAmountDiscount';

    protected $config;

    public static function create($config)
    {
        if (!isset($config['config']) || !isset($config['config'][0])) {
            return null;
        }

        if (!isset($config['name'])) {
            return null;
        }

        $discountConfig = $config['config'][0];
        if (!isset($discountConfig['amount']) || !isset($discountConfig['discount'])) {
            return null;
        }

        if (!isset($config['start_at']) || !isset($config['stop_at'])) {
            return null;
        }

        if (!$config['start_at'] instanceof \DateTime || !$config['stop_at'] instanceof \DateTime) {
            return null;
        }

        if (time() < $config['start_at']->getTimeStamp() || time() > $config['stop_at']->getTimeStamp()) {
            return null;
        }

        return parent::create($config);
    }

    public function process(Order $order, \PropelPDO $con = null)
    {
        $discountConfig = $this->config['config'][0];
        
        if($order->getOrderNoShipmentAmount() < $discountConfig['amount']){
            return;
        }

        if ($order->getOrderNoShipmentAmount() < $discountConfig['discount']) {
            $discountPrice = $order->getOrderNoShipmentAmount();
        } else {
            $discountPrice = $discountConfig['discount'];
        }

        $this->processed = true;

        $item = new OrderItem();
        $item->setQuantity(1);
        $item->setProductName("{$this->config['name']}");
        $item->setUnitPrice(-$discountPrice);
        $order->addDiscounts($item);
         
    }

}
