<?php
namespace Widget\Discount\TargetAmountBundle\Discount;

use Widget\DiscountBundle\Service\Discount\AbstractDiscount;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;


class TargetAmountDiscount extends AbstractDiscount
{

    protected $config;

    public static function create($config)
    {
        if (!isset($config['config']) || !isset($config['config'][0])) {
            return null;
        }

        if (!isset($config['name'])) {
            return null;
        }

        $discountConfig = $config['config'][0];
        if (!isset($discountConfig['amount']) || !isset($discountConfig['discount'])) {
            return null;
        }

        if (!isset($config['start_at']) || !isset($config['stop_at'])) {
            return null;
        }

        if (!$config['start_at'] instanceof \DateTime || !$config['stop_at'] instanceof \DateTime) {
            return null;
        }

        if (time() < $config['start_at']->getTimeStamp() || time() > $config['stop_at']->getTimeStamp()) {
            return null;
        }

        return parent::create($config);
    }

    public function process(Order $order, \PropelPDO $con = null)
    {
        $discountConfig = $this->config['config'];
        $ruleProcessed = false;
        foreach($discountConfig as $config){
            if($order->getOrderNoShipmentAmount() < $config['amount']){
                continue;
            }

            if ($order->getOrderNoShipmentAmount() < $config['discount']) {
                $discountPrice = $order->getOrderNoShipmentAmount();
            } else {
                $discountPrice = $config['discount'];
            }

            $discountName = $this->config['name'];
            if (isset($config['discount_name'])) {
                $discountName = $config['discount_name'];
            }

            $item = new OrderItem();
            $item->setQuantity(1);
            $item->setProductName("$discountName");
            $item->setUnitPrice(-$discountPrice);
            $order->addDiscounts($item);

            $ruleProcessed = true;
            if($ruleProcessed){
                break;
            }
        }

        if ($ruleProcessed) {
            $this->processed = true;
        }
         
    }

}
