<?php

namespace Widget\Discount\TargetAmountBundle\EventListener;


use JMS\DiExtraBundle\Annotation as DI;
use Widget\Discount\TargetAmountBundle\Discount\TargetAmountDiscount;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;

/**
 * @DI\Service()
 */
class TargetAmountListener
{
    /**
     * @DI\Observe(DiscountFactoryEvent::EVENT_NAME)
     */
    public function factoryClass(DiscountFactoryEvent $event)
    {
        $moduleArray = $event->getModule();
        if (!isset($moduleArray['class_name']) || $moduleArray['class_name'] != 'TargetAmountDiscount') {
            return;
        }
        $discountClass = TargetAmountDiscount::create($moduleArray);
        $event->setObject($discountClass);
    }
}