module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "name": {
      "label": "index.discount_shipment.name",
      "type": "text",
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "sort": {
      "label": "index.discount_shipment.sort",
      "type": "text",
      "sort": true
    },
    "start_at": {
      "label": "index.discount_shipment.start_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "stop_at": {
      "label": "index.discount_shipment.stop_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_DISCOUNT_SHIPMENT_WRITE"]
      "route": 'discount_shipment-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_DISCOUNT_SHIPMENT_WRITE"]
      "route": 'discount_shipment-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_DISCOUNT_SHIPMENT_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}