<?php

namespace Widget\Discount\ShipmentBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Discount\ShipmentBundle\Discount\ShipmentDiscount;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;

/**
 * @DI\Service()
 */
class ShipmentListener
{
    /**
     * @DI\Observe(DiscountFactoryEvent::EVENT_NAME)
     */
    public function factoryClass(DiscountFactoryEvent $event)
    {
        $moduleArray = $event->getModule();
        if (!isset($moduleArray['class_name']) || $moduleArray['class_name'] != ShipmentDiscount::CLASS_NAME) {
            return;
        }
        $discountClass = ShipmentDiscount::create($moduleArray);
        $event->setObject($discountClass);
    }
}