<?php

namespace Widget\Discount\ShipmentBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Discount\ShipmentBundle\EventListener\ShipmentListener;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;
use Widget\DiscountBundle\Model\DiscountModuleQuery;
use Widget\DiscountBundle\Service\Discount\DiscountInterface;

class ShipmentListenerTest extends BaseWebTestCase
{
    public function test_factoryClass()
    {
        // arrange
        $shipmentListener = $this->getMockBuilder(ShipmentListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function(){
                return DiscountModuleQuery::create()->findPk(4000)->toArray(\BasePeer::TYPE_FIELDNAME);
            });
        $event
            ->expects($this->once())
            ->method('setObject')
            ->willReturnCallback(function ($discountClassForTest){
                $this->assertInstanceOf(DiscountInterface::class, $discountClassForTest);
            });

        // act
        $shipmentListener->factoryClass($event);
    }

    public function test_factoryClass_bad_class_name()
    {
        // arrange
        $shipmentListener = $this->getMockBuilder(ShipmentListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function(){
                return array('class_name' => '不符合的class_name');
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('應該不能call');
            });

        // act
        $shipmentListener->factoryClass($event);
    }
}