<?php

namespace Widget\Discount\ShipmentBundle\Discount;

use Widget\DiscountBundle\Service\Discount\AbstractDiscount;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;

class ShipmentDiscount extends AbstractDiscount
{
    protected $config;

    public static function create($config)
    {
        if (!isset($config['config']) || !isset($config['config'][0])) {
            return null;
        }

        if (!isset($config['name'])) {
            return null;
        }

        $discountConfig = $config['config'][0];
        if (!isset($discountConfig['amount'])) {
            return null;
        }

        if (!isset($config['start_at']) || !isset($config['stop_at'])) {
            return null;
        }

        if (!$config['start_at'] instanceof \DateTime || !$config['stop_at'] instanceof \DateTime) {
            return null;
        }

        if (time() < $config['start_at']->getTimeStamp() || time() > $config['stop_at']->getTimeStamp()) {
            return null;
        }

        return parent::create($config);
    }

    public function process(Order $order, \PropelPDO $con = null)
    {
        $discountConfig = $this->config['config'][0];
        if($order->getOrderNoShipmentAmount() < $discountConfig['amount']){
            return;
        }

        $sumShipment = 0;
        /** @var OrderItem $shipment */
        foreach ($order->getShipments() as $shipment){
            $sumShipment += (int)$shipment->getUnitPrice() * (int)$shipment->getQuantity();
        }

        // 免運折扣
        $this->processed = true;
        $item = new OrderItem();
        $item->setQuantity(1);
        $item->setProductName("{$this->config['name']}");
        $item->setUnitPrice(-$sumShipment);
        $order->addDiscounts($item);
    }
}