module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "name": {
      "label": "index.discount_product.name",
      "type": "text",
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "sort": {
      "label": "index.discount_product.sort",
      "type": "text",
      "sort": true
    },
    "start_at": {
      "label": "index.discount_product.start_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "stop_at": {
      "label": "index.discount_product.stop_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_DISCOUNT_PRODUCT_WRITE"]
      "route": 'discount_product-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_DISCOUNT_PRODUCT_WRITE"]
      "route": 'discount_product-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_DISCOUNT_PRODUCT_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}