module.exports = (api) ->
  api.discountProduct =
    search: (data) ->
      api.request "GET", "/discount/products", data
    create: (data) ->
      api.request "POST", "/discount/products", data
    read: (id) ->
      api.request "GET", "/discount/product/#{id}"
    update: (id, data) ->
      api.request  "PUT", "/discount/product/#{id}", data
    delete: (id) ->
      api.request  "DELETE", "/discount/product/#{id}"
    batch: (ids, action, column) ->
      api.request  "PUT", "/discount/products",
        ids: ids
        action: action
        column: column
    getCategories:() ->
      api.request "GET", "/productcategorys/all"
    getRules: () ->
      new Promise (resolve, reject) ->
        choices = [
          { "id": "not_repeat", "name": "共用但不重複折" }
          { "id": "unique", "name": "只折第一個符合" }
          { "id": "all", "name": "共用且重複折扣" }
        ]
        resolve choices        