<?php

namespace Widget\Discount\ProductBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Discount\ProductBundle\Discount\ProductDiscount;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;

/**
 * @DI\Service()
 */
class ProductListener
{
    /**
     * @DI\Observe(DiscountFactoryEvent::EVENT_NAME)
     */
    public function factoryClass(DiscountFactoryEvent $event)
    {
        $moduleArray = $event->getModule();
        if (!isset($moduleArray['class_name']) || $moduleArray['class_name'] != 'ProductDiscount') {
            return;
        }
        $discountClass = ProductDiscount::create($moduleArray);
        $event->setObject($discountClass);
    }
}