<?php

namespace Widget\Discount\ProductBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Widget\CategoryBundle\Model\Category;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;
use Widget\ProductBundle\Model\ProductQuery;

/**
 * @Route("/discount/product")
 * @Security("has_role_or_superadmin('ROLE_DISCOUNT_PRODUCT_READ')") 設定權限
 */
class ProductController extends BaseController
{
    /**
     * @param Site $site
     * @return \ModelCriteria
     */
    protected function createQuery(Site $site)
    {
        // 手動加入 篩選條件
        $session = $this->get('session');
        $defaultFilterArray = array('filter' => array('ClassName' => 'ProductDiscount'));
        $filterArray = $session->get('backend_filter_Widget\Discount\ProductBundle\Controller\Backend\ProductController', array());
        $customFilterArray = $filterArray + $defaultFilterArray;
        $session->set('backend_filter_Widget\Discount\ProductBundle\Controller\Backend\ProductController', $customFilterArray);

        $query = $this->createBaseQuery($site);
        $this->buildSortQuery($query);
        $this->buildFilterQuery($query);
        return $query;
    }

    /**
     * 寫入時手動加入本 bundle 使用的折扣 Class 名稱
     */
    public function updateData($form)
    {
        /** @var DiscountModule $discountModule */
        $discountModule = $form->getData();

        if ($discountModule->isNew()) {
            $discountModule->setClassName('ProductDiscount');
        }

        parent::updateData($form);
    }


}