<?php

namespace Widget\Discount\PercentageBundle\Tests\Controller\BackendAPI;

use Backend\BaseBundle\Model\SiteUserQuery;
use Backend\BaseBundle\Tests\Fixture\BackendWebTestCase;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\DiscountBundle\Model\DiscountModuleQuery;

class PercentageControllerTest extends BackendWebTestCase
{
    public function test_createAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $params = array(
            'name' => '新的一般折扣',
            'class_name' => 'PercentageDiscount',
            'sort' => '100',
            'config' => array(),
            'start_at' => '2016-01-01',
            'stop_at' => '2016-12-31',
        );

        //act
        $this->client->request(
            'POST',
            $this->generateUrl('widget_discount_percentage_backendapi_percentage_create'),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();

        //assert
        $discountModule = DiscountModuleQuery::create()->findOneByName($params['name']);

        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $discountModule->getName());
        $this->assertEquals($params['class_name'], $discountModule->getClassName());
        $this->assertEquals($params['sort'], $discountModule->getSort());
        $this->assertEquals($params['config'], $discountModule->getConfig());
        $this->assertEquals($params['start_at'], $discountModule->getStartAt("Y-m-d"));
        $this->assertEquals($params['stop_at'], $discountModule->getStopAt("Y-m-d"));

        $discountModule->delete();
    }

    public function test_searchAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $searchParams = array(
            'page' => 1,
            'sort' => array(
                'name' => 'asc'
            ),
            'search' => array(
                'class_name' => 'PercentageDiscount',
            ),
        );

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_percentage_backendapi_percentage_search', $searchParams),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertArrayHasKey('pager', $responseArray);
        $this->assertArrayHasKey('page', $responseArray['pager']);
        $this->assertArrayHasKey('pages', $responseArray['pager']);
        $this->assertArrayHasKey('rows', $responseArray['pager']);

        $this->assertArrayHasKey('data', $responseArray);
        $this->assertArrayHasKey('name', $responseArray['data'][0]);
        $this->assertArrayHasKey('class_name', $responseArray['data'][0]);
        $this->assertArrayHasKey('sort', $responseArray['data'][0]);
        $this->assertArrayHasKey('start_at', $responseArray['data'][0]);
        $this->assertArrayHasKey('stop_at', $responseArray['data'][0]);

    }

    public function test_readAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $discountModule = DiscountModuleQuery::create()->findPk(3000);

        //act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_percentage_backendapi_percentage_read', array('id' => $discountModule->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();
        $responseArray = json_decode($response->getContent(), true);

        //assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($discountModule->getName(), $responseArray['name']);
        $this->assertEquals($discountModule->getClassName(), $responseArray['class_name']);
        $this->assertEquals($discountModule->getSort(), $responseArray['sort']);
        $this->assertEquals($discountModule->getStartAt(DATE_RFC3339), $responseArray['start_at']);
        $this->assertEquals($discountModule->getStopAt(DATE_RFC3339), $responseArray['stop_at']);
        $this->assertArrayHasKey('config', $responseArray);
    }

    public function test_updateAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $discountModule = DiscountModuleQuery::create()->findPk(3000);
        $originDiscountModuleArray = $discountModule->toArray();
        $params = array(
            'name' => '現折9999999%'
        );

        //act
        $this->client->request(
            'PUT',
            $this->generateUrl('widget_discount_percentage_backendapi_percentage_update', array('id' => $discountModule->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            ),
            json_encode($params)
        );
        $response = $this->client->getResponse();
        $discountModule->reload(true);

        // assert
        $this->assertTrue($response->isOk());
        $this->assertEquals($params['name'], $discountModule->getName());

        // reset
        $discountModule->fromArray($originDiscountModuleArray);
        $discountModule->save();
    }

    public function test_deleteAction()
    {
        //arrange
        $loginName = 'admin';
        $origin = 'http://localhost';
        $token = $this->createToken(SiteUserQuery::create()->findOneByLoginName($loginName), $origin);

        $discountName = "Percentage Discount";
        $discountModule = new DiscountModule();
        $discountModule->setName($discountName);
        $discountModule->setClassName('className');
        $discountModule->setSort(1);
        $discountModule->setStartAt('2016-01-01');
        $discountModule->setStopAt('2016-12-31');
        $discountModule->save();
        
        //act
        $this->client->request(
            'DELETE',
            $this->generateUrl('widget_discount_percentage_backendapi_percentage_delete', array('id' => $discountModule->getId())),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $discountModuleQuery = DiscountModuleQuery::create()->findOneByName($discountName);
        $this->assertTrue($response->isOk());
        $this->assertNull($discountModuleQuery);
    }
}