<?php

namespace Widget\Discount\PercentageBundle\Discount;

use Widget\DiscountBundle\Service\Discount\AbstractDiscount;
use Widget\OrderBundle\Model\Order;
use Widget\OrderBundle\Model\OrderItem;

class PercentageDiscount extends AbstractDiscount
{
    const CLASS_NAME = 'PercentageDiscount';
    
    protected $config;

    public static function create($config)
    {
        if (!isset($config['config']) || !isset($config['config'][0])) {
            return null;
        }

        $discountConfig = $config['config'][0];
        if (!isset($discountConfig['amount']) || !isset($discountConfig['percentage'])) {
            return null;
        }

        if (!isset($config['start_at']) || !isset($config['stop_at'])) {
            return null;
        }

        if (!$config['start_at'] instanceof \DateTime || !$config['stop_at'] instanceof \DateTime) {
            return null;
        }

        if (time() < $config['start_at']->getTimeStamp() || time() > $config['stop_at']->getTimeStamp()) {
            return null;
        }        

        return new static($config);
    }    

    public function process(Order $order, \PropelPDO $con = null)
    {
        $discountConfig = $this->config['config'][0];

        if($order->getOrderNoShipmentAmount() < $discountConfig['amount']){
            return;
        }
        $discountPercentage = round($discountConfig['percentage'] / 100, 2) ;
        $discountAmount = round($order->getOrderNoShipmentAmount() * $discountPercentage);

        if ($order->getOrderNoShipmentAmount() < $discountAmount) {
            $discountPrice = $order->getOrderNoShipmentAmount();
        } else {
            $discountPrice = $discountAmount;
        }

        $this->processed = true;
        $item = new OrderItem();
        $item->setQuantity(1);
        $item->setProductName("{$this->config['name']}");
        $item->setUnitPrice(-$discountPrice);
        $order->addDiscounts($item);
    }
}