<?php

namespace Widget\Discount\PercentageBundle\Controller\Backend;

use Backend\BaseBundle\Controller\BaseController;
use Backend\BaseBundle\Model\Site;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Widget\DiscountBundle\Model\DiscountModule;

/**
 * @Route("/discount/percentage")
 * @Security("has_role_or_superadmin('ROLE_DISCOUNT_PERCENTAGE_READ')") 設定權限
 */
class PercentageController extends BaseController
{
    /**
     * @param Site $site
     * @return \ModelCriteria
     */
    protected function createQuery(Site $site)
    {
        // 手動加入 篩選條件
        $session = $this->get('session');
        $defaultFilterArray = array('filter' => array('ClassName' => 'PercentageDiscount'));
        $filterArray = $session->get('backend_filter_Widget\Discount\PercentageBundle\Controller\Backend\PercentageController', array());
        $customFilterArray = $filterArray + $defaultFilterArray;
        $session->set('backend_filter_Widget\Discount\PercentageBundle\Controller\Backend\PercentageController', $customFilterArray);

        $query = $this->createBaseQuery($site);
        $this->buildSortQuery($query);
        $this->buildFilterQuery($query);
        return $query;
    }

    /**
     * 寫入時手動加入本 bundle 使用的折扣 Class 名稱
     */
    public function updateData($form)
    {
        /** @var DiscountModule $discountModule */
        $discountModule = $form->getData();
        if ($discountModule->isNew()) {
            $discountModule->setClassName('PercentageDiscount');
        }
        parent::updateData($form);
    }
}