<?php

namespace Widget\Discount\PercentageBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Discount\PercentageBundle\EventListener\PercentageListener;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;
use Widget\DiscountBundle\Service\Discount\DiscountInterface;

class PercentageListenerTest extends BaseWebTestCase
{
    public function test_factoryClass()
    {
        // arrange
        $percentageListener = $this->getMockBuilder(PercentageListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $getModuleConfig = array(
            'name' => 'Discount ',
            'class_name' => 'PercentageDiscount',
            'start_at' => new \DateTime('2000-01-01'),
            'stop_at' => new \DateTime('2099-01-31'),
            'config' => array(
                0 => array(
                    'amount' => 1,
                    'percentage' => 1
                )
            )
        );
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function() use($getModuleConfig){
                return $getModuleConfig;
            });
        $event
            ->expects($this->once())
            ->method('setObject')
            ->willReturnCallback(function ($discountClassForTest){
                $this->assertInstanceOf(DiscountInterface::class, $discountClassForTest);
            });

        // act
        $percentageListener->factoryClass($event);
    }

    public function test_factoryClass_bad_class_name()
    {
        // arrange
        $targetAmountListener = $this->getMockBuilder(PercentageListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject'))
            ->getMock();
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function(){
                return array('class_name' => '不符合的class_name');
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('應該不能call');
            });

        // act
        $targetAmountListener->factoryClass($event);
    }
}