<?php

namespace Widget\Discount\PercentageBundle\EventListener;

use JMS\DiExtraBundle\Annotation as DI;
use Widget\Discount\PercentageBundle\Discount\PercentageDiscount;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;

/**
 * @DI\Service()
 */
class PercentageListener
{
    /**
     * @DI\Observe(DiscountFactoryEvent::EVENT_NAME)
     */
    public function factoryClass(DiscountFactoryEvent $event)
    {
        $moduleArray = $event->getModule();
        if (!isset($moduleArray['class_name']) || $moduleArray['class_name'] != 'PercentageDiscount') {
            return;
        }
        $discountClass = PercentageDiscount::create($moduleArray);
        $event->setObject($discountClass);
    }
}