module.exports =
{
  "list": {
    "id": {
      "label": "#",
      "type": "id",
      "sort": true,
      "search": true
      searchConfig:
        key: "id"
        like: true
        type: "text"
    },
    "name": {
      "label": "index.discount_coupon.name",
      "type": "text",
      "quick": true,
      "search": true
      searchConfig:
        key: "name"
        like: true
        type: "text"
    },
    "sort": {
      "label": "index.discount_coupon.sort",
      "type": "text",
      "sort": true
    },
    "start_at": {
      "label": "index.discount_coupon.start_at",
      "type": "datetime-local",
      "sort": true
      defaultSorting: 'desc'
    },
    "stop_at": {
      "label": "index.discount_coupon.stop_at",
      "type": "datetime-local",
      "sort": true
    }
  },
  "extra": [
    {
      "name": "new",
      "label": "form.button.new",
      "roles": ["ROLE_DISCOUNT_COUPON_WRITE"]
      "route": 'discount_coupon-new'
    },
  ],
  "action": [
    {
      "name": "edit",
      "label": "action.edit",
      "roles": ["ROLE_DISCOUNT_COUPON_WRITE"]
      "route": 'discount_coupon-edit'
    },
    {
      "name": "delete",
      "label": "action.delete",
      "roles": ["ROLE_DISCOUNT_COUPON_WRITE"]
      "component": require 'components/backendbase/partial/list/table/actions/delete.vue'
    }
  ]
}