<?php

namespace Widget\Discount\CouponBundle\Controller\API;

use Backend\BaseBundle\Controller\API\BaseController;
use Faker\Provider\Uuid;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Widget\DiscountBundle\Model\DiscountCouponQuery;
use Widget\DiscountBundle\Model\DiscountGroup;
use Widget\DiscountBundle\Model\DiscountModule;
use Widget\MemberBundle\Model\Group;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Model\MemberQuery;
use Widget\MemberBundle\Service\DefaultGroupService;

/**
 * @Route("/discount/coupon")
 */
class CouponController extends BaseController
{
    /**
     * @Route("/{coupon}")
     * @Method("GET")
     */
    public function getAction(Request $request, $coupon)
    {
        $authorizedToken = $request->attributes->get('_authorizedToken');
        $amount = $request->query->get('amount');

        $discountCoupon = DiscountCouponQuery::create()
            ->filterByCouponCode($coupon)
            ->findOne();
        if ($discountCoupon == null) {
            return $this->createJsonResponse(array('message' => 'not found'), Response::HTTP_NOT_FOUND);
        }
        $discountModule = $discountCoupon->getDiscountModule();

        if(!$authorizedToken){
            $member = $this->createRandomMember();
            $memberId = $member->getId();
        } else{
            $memberId = $authorizedToken->getAuthData()['uid'];
        }

        $member = MemberQuery::create()->findPk($memberId);
        $memberGroup = $member->getGroups();

        $inGroup = false;
        /** @var Group $group */
        foreach ($memberGroup as $group) {
            /** @var DiscountGroup $discountGroup */
            foreach ($group->getDiscountGroups() as $discountGroup){
                /** @var DiscountModule $module */
                foreach ($discountGroup->getDiscountModules() as $module) {
                    if ($module->getId() == $discountModule->getId()) {
                        $inGroup = true;
                    }
                }
            }
        }

        if (!$authorizedToken){
            $member->delete();
        }

        if (!$inGroup) {
            return $this->createJsonResponse(array('message' => 'not in group'), Response::HTTP_FORBIDDEN);
        }

        if ( $amount < $discountModule->getConfig()[0]['amount'] ) {
            return $this->createJsonResponse(array('code' => 1, 'message' => 'not enough amount', 'amount' => $discountModule->getConfig()[0]['amount']), Response::HTTP_BAD_REQUEST);
        }

        if ( $discountModule->getStartAt()->getTimeStamp() >= time() || $discountModule->getStopAt()->getTimeStamp() <= time() ){
            return $this->createJsonResponse(array('code' => 2, 'message' => 'not in date range'), Response::HTTP_BAD_REQUEST);
        }

        return $this->createJsonResponse(array('status' => 'ok', 'name' => $discountModule->getName(), 'amount' => $discountModule->getConfig()[0]['amount']));

    }

    /**
     * @return Member mixed
     */
    protected function createRandomMember()
    {
        $uuidEmail = Uuid::uuid() . "@" . Uuid::uuid() . ".com";
        $member = new Member();
        $member->setEmail($uuidEmail);
        $member->save();
        /** @var DefaultGroupService $defaultGroupService */
        $defaultGroupService = $this->get('widget.member_bundle.service.default_group_service');
        $defaultGroupService->setMemberDefaultGroup($member);
        
        return $member;
    }
}