<?php

namespace Widget\Discount\CouponBundle\Tests\Controller\API;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Symfony\Component\HttpFoundation\Response;
use Widget\MemberBundle\Model\Member;
use Widget\MemberBundle\Token\MemberAuthToken;

class CouponControllerTest extends BaseWebTestCase
{
    public function test_getAction_no_this_coupon()
    {
        // arrange
        $slug = "dgfactor";
        $coupon = "No this coupon";
        $amount = 1000;
        $userId = 1001;

        $secret = $this->client->getContainer()->getParameter('secret');
        $origin = "http://localhost";
        $member = new Member();
        $member->setId($userId);

        $authToken = new MemberAuthToken($secret, $origin, $origin);
        $authToken->setMember($member);
        $token = $authToken->getJWTToken();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_coupon_api_coupon_get', array('amount' => $amount, 'coupon' => $coupon)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_NOT_FOUND, $response->getStatusCode());
    }

    public function test_getAction_not_in_group()
    {
        // arrange
        $slug = "dgfactor";
        $coupon = "amount";
        $amount = 1;
        $userId = 1001;

        $secret = $this->client->getContainer()->getParameter('secret');
        $origin = "http://localhost";
        $member = new Member();
        $member->setId($userId);

        $authToken = new MemberAuthToken($secret, $origin, $origin);
        $authToken->setMember($member);
        $token = $authToken->getJWTToken();

        // act
        $this->client->request(
            'GET',
            $this->generateUrl('widget_discount_coupon_api_coupon_get', array('amount' => $amount, 'coupon' => $coupon)),
            array(),
            array(),
            array(
                'HTTP_ORIGIN' => $origin,
                'HTTP_AUTHORIZATION' => "Bearer $token",
            )
        );
        $response = $this->client->getResponse();

        // assert
        $this->assertEquals(Response::HTTP_FORBIDDEN, $response->getStatusCode());
    }
}