abstractEdit = require "components/backendbase/actions/abstract-edit.coffee"

class DiscountCouponEdit extends abstractEdit
  _init: () ->
    require("components/widgetdiscountcoupon/actions/api/coupon.coffee") @api
  injectConfig: () ->
    require 'components/widgetdiscountcoupon/config/edit/coupon.coffee'
# 取得資料
  _getData: (id) ->
    @api.discountCoupon.read id
# 儲存表單
  save: () ->
    me = @
    promise = @api.discountCoupon.update @editSetting.dataRow.id, @editSetting.dataRow
    promise.then (result) ->
      return new Promise (subResolve, subReject) ->
        promises = []
        me.editSetting.dataRow.discount_coupon['id'] = result.id
        couponPromise = me.api.discountCoupon.updateCoupon me.editSetting.dataRow.id, me.editSetting.dataRow.discount_coupon
        promises.push couponPromise
        count = 0
        promises.map (promise) ->
          promise.then (subResult) ->
            count++
            if count == 1
              subResolve result
          promise.catch (subReason) ->

            subReject subReason

  create: () ->
    @editSetting.dataRow['class_name'] = 'CouponDiscount'
    if @editSetting.dataRow.discount_coupon == undefined
      @editSetting.dataRow.discount_coupon['coupon_code'] = ''
    me = @
    promise = @api.discountCoupon.create @editSetting.dataRow
    promise.then (result) ->
      return new Promise (subResolve, subReject) ->
        promises = []
        me.editSetting.dataRow.discount_coupon['id'] = result.id
        couponPromise = me.api.discountCoupon.createCoupon me.editSetting.dataRow.discount_coupon
        promises.push couponPromise
        count = 0
        promises.map (promise) ->
          promise.then (subResult) ->
            count++
            if count == 1
              subResolve result
          promise.catch (subReason) ->
            me.api.discountCoupon.delete result.id
            subReject subReason

module.exports = (api, id) ->
  new DiscountCouponEdit(api, id)