<?php

namespace Widget\Discount\CouponBundle\Controller\BackendAPI;

use Backend\BaseBundle\Controller\BackendAPI\BaseBackendAPIController;
use Backend\BaseBundle\Form\Type\APIFormTypeItem;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\Callback;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\ExecutionContextInterface;
use Widget\DiscountBundle\Model\DiscountCoupon;
use Widget\DiscountBundle\Model\DiscountCouponQuery;

/**
 * @Route("/discount/discountcoupon")
 * @Security("has_role_or_superadmin('ROLE_DISCOUNT_COUPON_READ')") 設定權限
 */
class DiscountCouponController extends BaseBackendAPIController
{
    /**
     * @return APIFormTypeItem[]
     */
    protected function getFormConfig()
    {
        return array(
            (new APIFormTypeItem('coupon_code'))->setOptions(array(
                'constraints' => array(
                    new NotBlank(array(
                        'message' => 'error.discount_coupon.coupon.missing_field',
                    )),
                    new Callback(function($value, ExecutionContextInterface $context){
                        $object = $context->getRoot()->getData();
                        $hasCoupons = DiscountCouponQuery::create()
                            ->filterByCouponCode($value)
                            ->find();
                        $id = explode("/", $_SERVER['REQUEST_URI'])[4];
                        /** @var DiscountCoupon $coupon */
                        foreach ($hasCoupons as $coupon) {
                            if ($hasCoupons && $coupon->getId() != $object->getId()){
                                $context->addViolation('validator.discount.coupon.code_unique');
                            }
                        }
                    }),
                )
            )),
        );
    }

    /**
     * 新增
     * @Route("s")
     * @Method({"POST"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNT_COUPON_WRITE')")
     */
    public function createAction(Request $request)
    {
        // 抽離出來做（同樣）動作 參數： 物件、content
        $response = json_decode($request->getContent(), true);
        $discountCoupon = new DiscountCoupon();
        $discountCoupon->setId($response['id']);
        return $this->doProcessForm($discountCoupon, $request->getContent());
    }

    /**
     * 更新
     * @Route("/{id}")
     * @Method({"PUT"})
     * @Security("has_role_or_superadmin('ROLE_DISCOUNT_COUPON_WRITE')")
     */
    public function updateAction(Request $request, $id)
    {
        $discountCoupon = DiscountCouponQuery::create()->filterById($id)->findOneOrCreate();
        return $this->doProcessForm($discountCoupon, $request->getContent());
    }    
}