<?php

namespace Widget\Discount\CouponBundle\Tests\EventListener;

use Backend\BaseBundle\Tests\Fixture\BaseWebTestCase;
use Widget\Discount\CouponBundle\EventListener\CouponListener;
use Widget\DiscountBundle\Event\DiscountFactoryEvent;
use Widget\DiscountBundle\Service\Discount\DiscountInterface;

class CouponListenerTest extends BaseWebTestCase
{
    public function test_factoryClass()
    {
        // arrange
        $percentageListener = $this->getMockBuilder(CouponListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject', 'getParameters'))
            ->getMock();
        $getModuleConfig = array(
            'id' => 3,
            'name' => 'Discount ',
            'class_name' => 'CouponDiscount',
            'start_at' => new \DateTime('2000-01-01'),
            'stop_at' => new \DateTime('2099-01-31'),
            'config' => array(
                0 => array(
                    'amount' => 1,
                    'discount' => 1
                )
            )
        );
        $parameters = array(
            'coupon_code' => 'amount'
        );
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function() use($getModuleConfig){
                return $getModuleConfig;
            });
        $event
            ->expects($this->once())
            ->method('getParameters')
            ->willReturnCallback(function() use($parameters){
                return $parameters;
            });
        $event
            ->expects($this->once())
            ->method('setObject')
            ->willReturnCallback(function ($discountClassForTest){
                $this->assertInstanceOf(DiscountInterface::class, $discountClassForTest);
            });

        // act
        $percentageListener->factoryClass($event);
    }

    public function test_factoryClass_bad_class_name()
    {
        // arrange
        $percentageListener = $this->getMockBuilder(CouponListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject', 'getParameters'))
            ->getMock();
        $getModuleConfig = array(
            'id' => 3,
            'name' => 'Discount ',
            'class_name' => 'Cou~pon',
            'start_at' => new \DateTime('2000-01-01'),
            'stop_at' => new \DateTime('2099-01-31'),
            'config' => array(
                0 => array(
                    'amount' => 1,
                    'discount' => 1
                )
            )
        );
        $parameters = array(
            'coupon_code' => 'amount'
        );
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function() use($getModuleConfig){
                return $getModuleConfig;
            });
        $event
            ->expects($this->never())
            ->method('getParameters')
            ->willReturnCallback(function() use($parameters){
                $this->fail('不該被call');
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('不該被call');
            });

        // act
        $percentageListener->factoryClass($event);
    }

    public function test_factoryClass_no_coupon_parameter()
    {
        // arrange
        $percentageListener = $this->getMockBuilder(CouponListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject', 'getParameters'))
            ->getMock();
        $getModuleConfig = array(
            'id' => 3,
            'name' => 'Discount ',
            'class_name' => 'CouponDiscount',
            'start_at' => new \DateTime('2000-01-01'),
            'stop_at' => new \DateTime('2099-01-31'),
            'config' => array(
                0 => array(
                    'amount' => 1,
                    'discount' => 1
                )
            )
        );
        $parameters = array(

        );
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function() use($getModuleConfig){
                return $getModuleConfig;
            });
        $event
            ->expects($this->once())
            ->method('getParameters')
            ->willReturnCallback(function() use($parameters){
                return $parameters;
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('不該被call');
            });

        // act
        $percentageListener->factoryClass($event);
    }

    public function test_factoryClass_coupon_code_not_find()
    {
        // arrange
        $percentageListener = $this->getMockBuilder(CouponListener::class)
            ->disableOriginalConstructor()
            ->setMethods(null)
            ->getMock();
        $event = $this->getMockBuilder(DiscountFactoryEvent::class)
            ->disableOriginalConstructor()
            ->setMethods(array('getModule', 'setObject', 'getParameters'))
            ->getMock();
        $getModuleConfig = array(
            'id' => 5,
            'name' => 'Discount ',
            'class_name' => 'CouponDiscount',
            'start_at' => new \DateTime('2000-01-01'),
            'stop_at' => new \DateTime('2099-01-31'),
            'config' => array(
                0 => array(
                    'amount' => 1,
                    'discount' => 1
                )
            )
        );
        $parameters = array(
            'coupon_code' => 'cannotuse'
        );
        $event
            ->expects($this->once())
            ->method('getModule')
            ->willReturnCallback(function() use($getModuleConfig){
                return $getModuleConfig;
            });
        $event
            ->expects($this->once())
            ->method('getParameters')
            ->willReturnCallback(function() use($parameters){
                return $parameters;
            });
        $event
            ->expects($this->never())
            ->method('setObject')
            ->willReturnCallback(function (){
                $this->fail('不該被call');
            });

        // act
        $percentageListener->factoryClass($event);
    }
}